#ifndef __LCD1_MENU_H 
#define __LCD1_MENU_H

#ifdef __cplusplus
 extern "C" {
#endif

#include <stdlib.h>
#include "MG32x02z_MID.h"
#include "LCD.h"
#include "MG32x02z_Flash_25_API.h"
#include "UserEvent.h"

#define DEFAULT_MENU_ID             0
#define MAIN_MENU_ID                1
#define USB_MENU_ID                 2
#define AUDIO_MENU_ID               3
#define PICTURE_MENU_ID             4
#define LIGHT_MENU_ID               5
#define SETTING_MENU_ID             6

#define Menu_Main                   7   // Setting / Demo / RGBLED / ARGB / LCDDisplay / Sound / Communication

#define Menu_Demo                   0   // Enable / Disable

#define Menu_SETTING                4   // Back / Idle Time / BLE / Update(DFU)
#define Menu_SETTING_IDLETIME       10  // 3Sec / 5Sec / 10Sec / 15Sec / 20Sec / 25Set / 30Sec / 45 Sec / 1min / 2min / 3min / 5min / 10 min
#define Menu_SETTING_BLE            2   // ON / OFF
#define Menu_SETTING_UPDATE         1   // FW Update

#define Menu_RGBLED                 4   // PWM / Breathing / Blinking / Stop
#define Menu_RGBLED_PWM             2   // Disable / Enable
#define Menu_RGBLED_BREATHING       2   // Disable / Enable
#define Menu_RGBLED_BLINKING        2   // Disable / Enable
#define Menu_RGBLED_STOP            2   // Disable / Enable

#define Menu_ARGB                   7   // Pattern1 / Pattern2/ Pattern3 / Pattern4 / Pattern5
#define Menu_ARGB_PATTERN1          2   // Disable / Enable
#define Menu_ARGB_PATTERN2          2   // Disable / Enable
#define Menu_ARGB_PATTERN3          2   // Disable / Enable
#define Menu_ARGB_PATTERN4          2   // Disable / Enable
#define Menu_ARGB_PATTERN5          2   // Disable / Enable

#define Menu_LCDDISPLAY             5   // Feature / Geometic / Font / Logo
#define Menu_LCDDISPLAY_Feature     9   // Feature
#define Menu_LCDDISPLAY_Geometic    9   // Disable / Enable
#define Menu_LCDDISPLAY_Font        9   // Disable / Enable
#define Menu_LCDDISPLAY_Logo        9   // Disable / Enable

#define Menu_Sound                  8   // Play / PlayRate / Voice / Record / RecordRate / Setting / Back / Home
#define Menu_Sound_Play             2   // Disable / Enable
#define Menu_Sound_Volume           4   // 2 / 8 / 16 / 32

#define Menu_COMMUNICTION           3   // BLE UART / USB Multimedia
#define Menu_COMMUNICTION_BLEUART   2   // 
#define Menu_COMMUNICTION_USBMULTIMEDIA 2 //

#define MenuL2SettingSelect         5   // Speed / BLE / WIFI
#define MenuL3USB                   2   // Disable / Enable
#define MenuL3BLE                   2   // Disable / Enable
#define MenuL3WIFI                  2   // Disable / Enable

enum UMenu{
    MainMenu,
    RGBMenu,
    LCDMenu,
    SoundMenu,
    ARGBMenu,
    CommunicationMenu,
    DemoMenu,
    SettingMenu,
};

typedef struct{
    __IO uint32_t Frame;
    __IO uint32_t GUI_Menu;
    __IO uint32_t GUI_Select;
    __IO uint32_t GUI_Option;
    __IO uint32_t GUI_Item;
    __IO uint32_t GUI_OldMenu;
}GUIMenu_HandleTypedef;


extern __IO uint8_t gOldMenu;
extern __IO uint8_t gOldSelect;

extern uint32_t const IdleTimeValue[];

extern GUIMenu_HandleTypedef gUMenu;

void GUIMenu(GUIMenu_HandleTypedef *UMenu, UEvent_HandleTypedef *UEvent);
void LCD_1st_Show(void);
void AutoDemo(GUIMenu_HandleTypedef *UMenu, UEvent_HandleTypedef *UEvent);

#ifdef __cplusplus
}
#endif

#endif


